"use client"

import { DialogDescription, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import { InputCopy } from "@/components/ui/input.copy";
import { ScrollArea } from "@/components/ui/scroll-area";
import { Separator } from "@/components/ui/separator";
import { TransformedAgency } from "@/types/transformers";
import { ComponentWithClassName } from "@/types/utils";

export function WorkflowDialogView({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedAgency> }>) {
  return (
    <>
      <DialogHeader className={className}>
        <DialogTitle>Details</DialogTitle>
        <DialogDescription>Currently viewing details about &apos;<span className="font-mono font-bold">{data.name}</span>&apos;.</DialogDescription>
      </DialogHeader>

      <ScrollArea className="h-fit w-full pr-3">
        <div className="grid max-h-96 flex-col gap-4">
          <InputCopy defaultValue={data.gtfsId} label={"Agency identifier"} />

          <InputCopy defaultValue={data.name} label={"Agency name"} />

          <InputCopy defaultValue={data.url} label={"Website"} />

          <InputCopy defaultValue={data.phone} label={"Phone number"} />

          <InputCopy defaultValue={data.path} label={"AWS Upload Path"} />

          <Separator className="bg-transparent" />
        </div>
      </ScrollArea>
    </>
  )
}

